/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.DrawLineElement;
import acm.graphics.EndRegionElement;
import acm.graphics.FinalPathElement;
import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.graphics.PathElement;
import acm.graphics.PathState;
import acm.graphics.PenImage;
import acm.graphics.SetColorElement;
import acm.graphics.SetLocationElement;
import acm.graphics.StartRegionElement;
import acm.util.Animator;
import acm.util.ErrorException;
import acm.util.MediaTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;

public class GPen
extends GObject {
    private static PathElement finalElement = new FinalPathElement();
    private Animator animator;
    private double xScale;
    private double yScale;
    private boolean regionOpen;
    private boolean regionStarted;
    private boolean penVisible = false;
    private ArrayList path = new ArrayList();
    private Image penImage;
    private int delayCount;
    private Color fillColor;

    public GPen() {
        this.animator = new Animator();
        this.setSpeed(1.0);
        this.erasePath();
    }

    public GPen(double d, double d2) {
        this();
        this.setLocation(d, d2);
    }

    public void erasePath() {
        this.path = new ArrayList();
        this.xScale = 1.0;
        this.yScale = 1.0;
        this.regionOpen = false;
        this.regionStarted = false;
        this.repaint();
    }

    public void setLocation(double d, double d2) {
        if (this.regionStarted) {
            throw new ErrorException("It is illegal to move the pen while you are defining a filled region.");
        }
        super.setLocation(d, d2);
        this.animator.delay();
    }

    public void drawLine(double d, double d2) {
        double d3 = this.getX();
        double d4 = this.getY();
        ArrayList arrayList = this.path;
        synchronized (arrayList) {
            if (!this.regionStarted) {
                this.path.add(new SetLocationElement(d3, d4));
                this.regionStarted = this.regionOpen;
            }
            this.path.add(new DrawLineElement(d, d2));
        }
        super.setLocation(d3 + d, d4 + d2);
        this.animator.delay();
    }

    public final void drawPolarLine(double d, double d2) {
        double d3 = d2 * Math.PI / 180.0;
        this.drawLine(d * Math.cos(d3), -d * Math.sin(d3));
    }

    public void setColor(Color color) {
        if (this.regionStarted) {
            throw new ErrorException("It is illegal to change the color while you are defining a filled region.");
        }
        ArrayList arrayList = this.path;
        synchronized (arrayList) {
            this.path.add(new SetColorElement(color));
        }
        super.setColor(color);
    }

    public void setFillColor(Color color) {
        if (this.regionStarted) {
            throw new ErrorException("It is illegal to change the fill color while you are defining a filled region.");
        }
        this.fillColor = color;
    }

    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    public void startFilledRegion() {
        if (this.regionOpen) {
            throw new ErrorException("You are already filling a region.");
        }
        this.regionOpen = true;
        this.regionStarted = false;
        ArrayList arrayList = this.path;
        synchronized (arrayList) {
            this.path.add(new StartRegionElement(this.fillColor));
        }
    }

    public void endFilledRegion() {
        if (!this.regionOpen) {
            throw new ErrorException("You need to call startFilledRegion before you call endFilledRegion.");
        }
        this.regionOpen = false;
        this.regionStarted = false;
        ArrayList arrayList = this.path;
        synchronized (arrayList) {
            this.path.add(new EndRegionElement());
        }
        this.repaint();
    }

    public void showPen() {
        this.penVisible = true;
        this.repaint();
        this.animator.delay();
    }

    public void hidePen() {
        this.penVisible = false;
        this.repaint();
        this.animator.delay();
    }

    public boolean isPenVisible() {
        return this.penVisible;
    }

    public void setSpeed(double d) {
        this.animator.setSpeed(d);
    }

    public double getSpeed() {
        return this.animator.getSpeed();
    }

    public void scale(double d, double d2) {
        this.xScale = d;
        this.yScale = d2;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        PathState pathState = new PathState();
        pathState.sx = this.xScale;
        pathState.sy = this.yScale;
        ArrayList arrayList = this.path;
        synchronized (arrayList) {
            int n = this.path.size();
            int n2 = 0;
            while (n2 < n) {
                PathElement pathElement = (PathElement)this.path.get(n2);
                pathElement.paint(graphics, pathState);
                ++n2;
            }
        }
        finalElement.paint(graphics, pathState);
        if (this.penVisible) {
            this.drawPen(graphics);
        }
    }

    public GRectangle getBounds() {
        PathState pathState = new PathState();
        GRectangle gRectangle = new GRectangle(-1.0, -1.0, -1.0, -1.0);
        pathState.sx = this.xScale;
        pathState.sy = this.yScale;
        ArrayList arrayList = this.path;
        synchronized (arrayList) {
            int n = this.path.size();
            int n2 = 0;
            while (n2 < n) {
                PathElement pathElement = (PathElement)this.path.get(n2);
                pathElement.updateBounds(gRectangle, pathState);
                ++n2;
            }
        }
        return gRectangle;
    }

    public boolean contains(double d, double d2) {
        return false;
    }

    public void setPenImage(Image image) {
        this.penImage = MediaTools.loadImage(image);
    }

    public Image getPenImage() {
        if (this.penImage == null) {
            this.penImage = PenImage.getImage();
        }
        return this.penImage;
    }

    protected void drawPen(Graphics graphics) {
        Component component = this.getComponent();
        if (component == null) {
            return;
        }
        if (this.penImage == null) {
            this.penImage = PenImage.getImage();
        }
        int n = this.penImage.getWidth(component);
        int n2 = this.penImage.getHeight(component);
        int n3 = (int)Math.round(this.getX());
        int n4 = (int)Math.round(this.getY());
        graphics.drawImage(this.penImage, n3 - n / 2, n4 - n2 / 2, component);
    }

    protected Rectangle getPenBounds() {
        Component component = this.getComponent();
        if (component == null) {
            return new Rectangle();
        }
        if (this.penImage == null) {
            this.penImage = PenImage.getImage();
        }
        int n = this.penImage.getWidth(component);
        int n2 = this.penImage.getHeight(component);
        int n3 = (int)Math.round(this.getX());
        int n4 = (int)Math.round(this.getY());
        return new Rectangle(n3 - n / 2, n4 - n2 / 2, n, n2);
    }

    private Rectangle getAWTRectangle(double d, double d2, double d3, double d4) {
        return new Rectangle((int)Math.min(d, d + d3), (int)Math.min(d2, d2 + d4), (int)Math.abs(d3), (int)Math.abs(d4));
    }
}

